/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterCommentNode;

public class FormatterCSSCommentNode
extends FormatterCommentNode {
    private final boolean isFirstLine;
    private final boolean isMultiLine;

    public FormatterCSSCommentNode(IFormatterDocument document, int startOffset, int endOffset, boolean isMultiLine, boolean isFirstLine) {
        super(document, startOffset, endOffset);
        this.isMultiLine = isMultiLine;
        this.isFirstLine = isFirstLine;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean currentCommentState = context.isComment();
        context.setComment(true);
        if (this.getDocument().getBoolean(this.getWrappingKey())) {
            boolean savedWrapping = context.isWrapping();
            context.setWrapping(true);
            this.writeCommentLine(visitor, context, this.getStartOffset(), this.getEndOffset());
            context.setWrapping(savedWrapping);
        } else {
            this.writeCommentLine(visitor, context, this.getStartOffset(), this.getEndOffset());
        }
        context.setComment(currentCommentState);
    }

    protected void writeCommentLine(IFormatterWriter visitor, IFormatterContext context, int startOffset, int endOffset) {
        if (!visitor.endsWithNewLine() && !this.isFirstLine && this.isMultiLine) {
            visitor.writeLineBreak(context);
        }
        if (!this.isMultiLine) {
            visitor.write(context, startOffset, endOffset);
        } else {
            if (!this.isFirstLine) {
                visitor.ensureLineStarted(context);
                visitor.writeText(context, " ", false);
            }
            visitor.write(context, startOffset, endOffset);
        }
    }

    public String getWrappingKey() {
        return "css.formatter.wrap.comments";
    }
}

